%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Reads C, K, k_dof from csv files saved during virtual experiment, for delta fit trajectory
function [C, K, k_dof] = get_data_1() %fipped order of C K


% Ideal Case
TC = table2array(readtable('test_fwd_kin_ideal_tool_3000.csv'));
% Worst Case
%TC = table2array(readtable('test_fwd_kin_sys_error1_tool_3000.csv'));
% Realistic Case
%TC = table2array(readtable('test_fwd_kin_sys_error2_tool_3000.csv'));

% In the report, "Worst Case" is called Model 2. Here, it is called Model
% 1 and realistic model is called Model 2.

% All Cases (for 3000 points)
TK1 = table2array(readtable('delta_tool_mk2_3000.csv'));

% Noting Known dimensions in the workspace
bh_pose = [-0.09 0.147 0.449];% 0 0 0];
ee_0_w = [0.75643 -0.1469409 0.29483197 0 0 0];

% Initiate variables
N = size(TK1, 1);
C = zeros(4,4,N);
T = zeros(4,4,N);
K = zeros(4,4,N);
k_dof = zeros(N, 5);

% Calculate forward kinematics, and convert end effector and tool tip pose
%to homogeneous transformation matrices

for i = 1:N
    % Forward Kinematis
    kg1 = TK1(i,:).*1000;
    k_dof(i,:) = kg1;
    Rk = rotx(kg1(4))*roty(kg1(5));
    k1 = forwardKinematics(kg1(1), kg1(2), kg1(3), kg1(4), kg1(5));
    kg_t = k1(1:3) - [0 0 268.9]' + [0 0 0.54083*1000]';% 
    % -[0 0 268.9]' transformation due to AMBF, + [ 0 0 0.54083]*1000 due to the way 
    % we generated the trajectory to cover a conservative workspace
    K(:,:,i) = [Rk kg_t; 0 0 0 1];
    
    % End effector pose
    c1 = TC(i,:);
    c_t = c1(1:3)'*1000 - bh_pose'*1000;% %!!! + bh_pose(1:3)'*1000;%+ [0 0 268.9]';%+ bh_pose'*1000 ; %- bh_pose(1:3)' - [0 0 268.9]';
    Rc = rotx(c1(4))*roty(c1(5))*rotz(c1(6));
    C(:,:,i) = [Rc c_t; 0 0 0 1];
end
end